//
//  MCMergeTokenTextStorage.h
//  TokenMergeTest
//
//  Created by Alykhan Jetha on 30/10/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCMergeTokenAttachment;

@interface MCMergeTokenTextStorage : NSTextStorage {
	NSMutableAttributedString *_realStorage;
}

- (NSString *)string;
- (NSDictionary *)attributesAtIndex:(unsigned)index effectiveRange:(NSRangePointer)aRange;
- (void)replaceCharactersInRange:(NSRange)aRange withString:(NSString *)str;
- (void)setAttributes:(NSDictionary *)attributes range:(NSRange)aRange;

// you should call this while there are no layout managers attached
- (void)replaceStorageWithAttributedString:(NSMutableAttributedString *)attributedString;

- (void)insertMergeTokenAttachment:(MCMergeTokenAttachment *)attach 
					withAttributes:(NSDictionary *)attributes 
						   inRange:(NSRange)range;

- (void)appendMergeTokenAttachment:(MCMergeTokenAttachment *)attach 
					withAttributes:(NSDictionary *)attributes;

- (void)insertMergeTokenWithKeyPath:(NSString *)keyPath 
							  label:(NSString *)aLabel 
						 attributes:(NSDictionary *)attributes 
							inRange:(NSRange)range;

- (void)insertMergeTokenWithKeyPath:(NSString *)keyPath
						  formatter:(NSFormatter *)aFormatter
							  label:(NSString *)aLabel 
						 attributes:(NSDictionary *)attributes 
							inRange:(NSRange)range;

- (MCMergeTokenAttachment *)insertMergeTokenWithKeyPath:(NSString *)keyPath
											  formatter:(NSFormatter *)aFormatter
										  formatterCode:(int)aFormatterCode
										formatterFormat:(NSString *)aFormatString
												  label:(NSString *)aLabel
											 attributes:(NSDictionary *)attributes 
												inRange:(NSRange)range;

- (void)appendMergeTokenWithKeyPath:(NSString *)keyPath 
							  label:(NSString *)aLabel 
						 attributes:(NSDictionary *)attributes;

- (void)appendMergeTokenWithKeyPath:(NSString *)keyPath 
						  formatter:(NSFormatter *)aFormatter
							  label:(NSString *)aLabel 
						 attributes:(NSDictionary *)attributes;

- (MCMergeTokenAttachment *)appendMergeTokenWithKeyPath:(NSString *)keyPath 
											  formatter:(NSFormatter *)aFormatter
										  formatterCode:(int)aFormatterCode
										formatterFormat:(NSString *)aFormatString
												  label:(NSString *)aLabel 
											 attributes:(NSDictionary *)attributes;

@end
